#include <stdlib.mqh>
//+------------------------------------------------------------------+
//|                                        KaseCD Peak oscilator.mq4 |
//|                                    Copyright  2006, Yousky Soft |
//|                                            http://yousky.free.fr |
//|                                                                  |
//+------------------------------------------------------------------+

#property copyright " Jeremy Burt"
#property link      ""

#property indicator_separate_window
#property indicator_color1 Blue
#property indicator_buffers 2
#property indicator_color2 Red

//+------------------------------------------------------------------+
//| Common External variables                                        |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| External variables                                               |
//+------------------------------------------------------------------+
extern double offset = 8;
extern double initial = 65;

//+------------------------------------------------------------------+
//| Special Convertion Functions                                     |
//+------------------------------------------------------------------+

int LastTradeTime;
double ExtHistoBuffer[];
double ExtHistoBuffer2[];

void SetLoopCount(int loops)
{
}

void SetIndexValue(int shift, double value)
{
  ExtHistoBuffer[shift] = value;
}

void SetIndexValue2(int shift, double value)
{
  ExtHistoBuffer2[shift] = value;
}

//+------------------------------------------------------------------+
//| End                                                              |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Initialization                                                   |
//+------------------------------------------------------------------+

int init()
{
   SetIndexStyle(0, DRAW_HISTOGRAM, STYLE_SOLID);
   SetIndexBuffer(0, ExtHistoBuffer);
   SetIndexStyle(1, DRAW_LINE, STYLE_SOLID);
   SetIndexBuffer(1, ExtHistoBuffer2);
   return(0);
}
int start()
{
//+------------------------------------------------------------------+
//| Local variables                                                  |
//+------------------------------------------------------------------+
double RWH = 0;
double RWL = 0;
double PK = 0;
double kcd = 0;
double var1 = 0;
double var2 = 0;
double LN = 0;
double refL = 0;
double refH = 0;
double temp = 0;
double mn = 0;
double sd = 0;
double temp1 = 0;
double temp2 = 0;
double totalsd = 0;
double ctr = 1;
double mean = 1;
double sum = 0;
int shift = 0;
double dummy = 0;
double prevkcd = 0;

/*[[
	Name := KaseCD Peak oscilator
	Author := Jeremy Burt
	Separate Window := Yes
	First Color := Blue
	First Draw Type := Histogram
	First Symbol := 217
	Use Second Data := Yes
	Second Color := Red
	Second Draw Type := Line
	Second Symbol := 218
]]*/
   
   
 
 
SetLoopCount(0);
// loop from first bar to current bar (with shift=0)
for(shift=Bars-1;shift>=0 ;shift--){ 
  mean=(High[shift]+Low[shift]+Close[shift])/3;
  sum += Close;
  ctr++;
} 


mean=sum/ctr;

for(shift=Bars-1;shift>=0 ;shift--){ 
    if( refL ==  Lowest(NULL, 0, MODE_LOW,offset,offset) ) dummy=shift ; else refL=Low;
    if( refH ==  Highest(NULL, 0, MODE_HIGH,offset,offset) )  dummy=shift ; else refH = High;
    if (iATR(NULL, 0, initial,shift) != 0)
    {
	    RWH = (High - refH)/(iATR(NULL, 0, initial,shift)*MathSqrt(initial));
	    RWL = (Low-refL)/(iATR(NULL, 0, initial,shift)*MathSqrt(initial));
	 }
    
	PK = iMA(NULL, 0, iMA(NULL, 0, initial, 0, RWH - RWL, PRICE_CLOSE, shift), 0, MODE_LWMA, PRICE_CLOSE, shift);
	kcd = PK - iMA(NULL, 0, PK, offset, MODE_EMA, PRICE_CLOSE, shift);
	
	sd = (mean - Close)/shift;
	
	if( (mn + 1.33*sd >2.08) ) var1 = mn+1.33*sd
	 ; else var1 = 2.08; 
	if( (mn - (1.33*sd)<-1.92 )) var2 = (mn-(1.33*sd)) 
	 ; else var2 = -1.92;
	
	
	if( prevkcd > kcd ) dummy= kcd ; else temp1 = 0;
	if( kcd > prevkcd  ) dummy = kcd ; else temp2=0;
	//if temp1 > 0 then temp1 = dummy else temp2 = dummy;
	
	prevkcd = kcd;
	SetIndexValue(shift, dummy);
	SetIndexValue2(shift, kcd);
} 




  return(0);
}